
#ifndef _1_CRYS_ATP_TST_Defines_h_H
#define _1_CRYS_ATP_TST_Defines_h_H
#endif
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Dec 02 11:21:17 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_Defines.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
#include "MW_ATP_defines.h"
#include "MW_ATP_UTIL_funcs.h"

/************************ Global Data **************************/
extern CRYSError_t      TST_ATP_Error;
extern DxUint8_t	    TST_ATP_EncryptDecryptFlag;
extern CRYS_Version_t   TST_ATP_CRYS_version;
/************************ Defines ******************************/
#define TESTPASS 	                     0
#define TESTFAIL 	                     1

/* define for enabling performance tests */
/*----------------------------------------*/
#define TST_ENABLE_PERFORMANCE_TST 0
#if TST_ENABLE_PERFORMANCE_TST
#define TICKS_PER_SECOND 1
#define TST_DEVIDE_TO_CONVERT_BYTES_TO_MBIT  (1000000/8)
extern DxUint32_t TST_Timer;
extern DxUint32_t TST_PerformanceDataSize;
extern float TST_PerformanceMasure;
#endif
/* Defines for including and excluding test data */
/*-----------------------------------------------*/
/*AES*/
#ifdef CRYS_NO_AES_SUPPORT
    #define TST_USE_AES_16BYTE_DATA   0
    #define TST_USE_AES_32BYTE_DATA   0
    #define TST_USE_AES_64BYTE_DATA   0
    #define TST_USE_AES_512BYTE_DATA  0
    #define TST_USE_AES_1536BYTE_DATA 0

    #define TST_USE_AES_192_KEY       0
    #define TST_USE_AES_256_KEY       0

#else 
    #define TST_USE_AES_16BYTE_DATA   1
    #define TST_USE_AES_32BYTE_DATA   1
    #define TST_USE_AES_64BYTE_DATA   1
    #define TST_USE_AES_512BYTE_DATA  1
    #define TST_USE_AES_1536BYTE_DATA 1

    #define TST_USE_AES_192_KEY       1
    #define TST_USE_AES_256_KEY       1
#endif

/*DES*/
#ifdef CRYS_NO_DES_SUPPORT
    #define TST_USE_DES_16BYTE_DATA   0
    #define TST_USE_DES_32BYTE_DATA   0
    #define TST_USE_DES_512BYTE_DATA  0
    #define TST_USE_DES_1536BYTE_DATA 0
#else
    #define TST_USE_DES_16BYTE_DATA   1
    #define TST_USE_DES_32BYTE_DATA   1
    #define TST_USE_DES_512BYTE_DATA  1
    #define TST_USE_DES_1536BYTE_DATA 1
#endif

/*HASH*/
#ifdef CRYS_NO_HASH_SUPPORT
    #define TST_USE_HASH_0BYTE_DATA    0
    #define TST_USE_HASH_16BYTE_DATA   0
    #define TST_USE_HASH_32BYTE_DATA   0
    #define TST_USE_HASH_512BYTE_DATA  0
    #define TST_USE_HASH_1536BYTE_DATA 0
#else
    #define TST_USE_HASH_0BYTE_DATA    1
    #define TST_USE_HASH_16BYTE_DATA   1
    #define TST_USE_HASH_32BYTE_DATA   1
    #define TST_USE_HASH_512BYTE_DATA  1
    #define TST_USE_HASH_1536BYTE_DATA 1
#endif

/*HMAC*/
#ifdef CRYS_NO_HMAC_SUPPORT
    #define TST_USE_HMAC_0BYTE_DATA    0
    #define TST_USE_HMAC_28BYTE_DATA   0
    #define TST_USE_HMAC_32BYTE_DATA   0
    #define TST_USE_HMAC_65BYTE_DATA   0
    #define TST_USE_HMAC_500BYTE_DATA  0
    #define TST_USE_HMAC_1536BYTE_DATA 0
#else
    #define TST_USE_HMAC_0BYTE_DATA    1
    #define TST_USE_HMAC_28BYTE_DATA   1
    #define TST_USE_HMAC_32BYTE_DATA   1
    #define TST_USE_HMAC_65BYTE_DATA   1
    #define TST_USE_HMAC_500BYTE_DATA  1
    #define TST_USE_HMAC_1536BYTE_DATA 1
#endif

/*RC4*/
#ifdef CRYS_NO_RC4_SUPPORT
    #define TST_USE_RC4_16BYTE_DATA   0
    #define TST_USE_RC4_32BYTE_DATA   0
    #define TST_USE_RC4_512BYTE_DATA  0
    #define TST_USE_RC4_1536BYTE_DATA 0
#else
    #define TST_USE_RC4_16BYTE_DATA   1
    #define TST_USE_RC4_32BYTE_DATA   1
    #define TST_USE_RC4_512BYTE_DATA  1
    #define TST_USE_RC4_1536BYTE_DATA 1
#endif

/*RSA*/
#ifdef CRYS_NO_PKI_SUPPORT
    #define TST_USE_RSA_512_KEY    0
    #define TST_USE_RSA_1024_KEY   0
    #define TST_USE_RSA_2048_KEY   0
#else 
    #define TST_USE_RSA_512_KEY    1
    #define TST_USE_RSA_1024_KEY   1
    #define TST_USE_RSA_2048_KEY   1
#endif

/*DH*/
#ifdef CRYS_NO_DH_SUPPORT
    #define TST_USE_DH_512_PRIME    0 
    #define TST_USE_DH_1024_PRIME   0
    #define TST_USE_DH_2048_PRIME   0
#else 
    #define TST_USE_DH_512_PRIME    1 
    #define TST_USE_DH_1024_PRIME   1
    #define TST_USE_DH_2048_PRIME   1
#endif

/*ECC*/
#ifdef CRYS_NO_ECPKI_SUPPORT
    #define TST_USE_ECC_16BYTE_DATA  0
    #define TST_USE_ECC_23BYTE_DATA  0
    #define TST_USE_ECC_27BYTE_DATA  0
    #define TST_USE_ECC_31BYTE_DATA  0
    #define TST_USE_ECC_47BYTE_DATA  0
    #define TST_USE_ECC_48BYTE_DATA  0
    #define TST_USE_ECC_64BYTE_DATA  0 
    #define TST_USE_ECC_128BYTE_DATA 0 
    #define TST_USE_ECC_256BYTE_DATA 0
    #define TST_USE_ECC_512BYTE_DATA 0 
    #define TST_USE_ECC_DH_DATA      0 
#else
    #define TST_USE_ECC_16BYTE_DATA  1
    #define TST_USE_ECC_23BYTE_DATA  1
    #define TST_USE_ECC_27BYTE_DATA  1
    #define TST_USE_ECC_31BYTE_DATA  1
    #define TST_USE_ECC_47BYTE_DATA  1
    #define TST_USE_ECC_48BYTE_DATA  1
    #define TST_USE_ECC_64BYTE_DATA  1 
    #define TST_USE_ECC_128BYTE_DATA 1 
    #define TST_USE_ECC_256BYTE_DATA 1
    #define TST_USE_ECC_512BYTE_DATA 1 
    #define TST_USE_ECC_DH_DATA      1 
#endif

/*RND*/
#define TST_USE_RND_DATA         1
/*OTF*/
#ifdef CRYS_NO_OTF_SUPPORT
    #define TST_USE_OTF_BYPASS       			    0
    #define TST_USE_OTF_DIN_TO_AES_TO_DOUT          0
    #define TST_USE_OTF_DIN_TO_DES_TO_DOUT		    0
    #define TST_USE_OTF_DIN_TO_HASH				    0
    #define TST_USE_OTF_DIN_TO_AES_TO_HASH          0
    #define TST_USE_OTF_DIN_TO_AES_AND_HASH_TO_DOUT 0
    #define TST_USE_OTF_DIN_TO_AES_TO_HASH_AND_DOUT 0
    #define TST_USE_OTF_DIN_TO_DES_TO_HASH          0
    #define TST_USE_OTF_DIN_TO_DES_AND_HASH_TO_DOUT 0
    #define TST_USE_OTF_DIN_TO_AES_MAC              0
    #define TST_USE_OTF_DIN_TO_HASH_AND_DOUT		0
    #define TST_USE_OTF_DIN_TO_AES_MAC_AND_TO_DOUT  0

    #define TST_USE_DESCSI_DMA_TO_CSI   0
    #define TST_USE_DESCSI_DMA_TO_DMA   0
    #define TST_USE_DESCSI_CSI_TO_DMA   0

    #define TST_USE_AESCSI_DMA_TO_CSI   0
    #define TST_USE_AESCSI_DMA_TO_DMA   0
    #define TST_USE_AESCSI_CSI_TO_DMA   0

    #define TST_USE_HASHCSI_DMA_TO_DMA  0
    #define TST_USE_HASHCSI_CSI_TO_DMA  0

    #define TST_USE_HMAC_DMA_TO_DMA     0
    #define TST_USE_HMAC_CSI_TO_DMA     0

#else 
    #define TST_USE_OTF_BYPASS       			    1
    #define TST_USE_OTF_DIN_TO_AES_TO_DOUT          1
    #define TST_USE_OTF_DIN_TO_DES_TO_DOUT		    1
    #define TST_USE_OTF_DIN_TO_HASH				    1
    #define TST_USE_OTF_DIN_TO_AES_TO_HASH          1
    #define TST_USE_OTF_DIN_TO_AES_AND_HASH_TO_DOUT 1
    #define TST_USE_OTF_DIN_TO_AES_TO_HASH_AND_DOUT 1
    #define TST_USE_OTF_DIN_TO_DES_TO_HASH          1
    #define TST_USE_OTF_DIN_TO_DES_AND_HASH_TO_DOUT 1
    #define TST_USE_OTF_DIN_TO_AES_MAC              1
    #define TST_USE_OTF_DIN_TO_HASH_AND_DOUT		1
    #define TST_USE_OTF_DIN_TO_AES_MAC_AND_TO_DOUT  1

    #define TST_USE_DESCSI_DMA_TO_CSI   1
    #define TST_USE_DESCSI_DMA_TO_DMA   1
    #define TST_USE_DESCSI_CSI_TO_DMA   1

    #define TST_USE_AESCSI_DMA_TO_CSI   1
    #define TST_USE_AESCSI_DMA_TO_DMA   1
    #define TST_USE_AESCSI_CSI_TO_DMA   1

    #define TST_USE_HASHCSI_DMA_TO_DMA  1
    #define TST_USE_HASHCSI_CSI_TO_DMA  1
    #define TST_USE_HMAC_DMA_TO_DMA     1
    #define TST_USE_HMAC_CSI_TO_DMA     1
#endif

/*OTF MC */


#define TST_USE_OTF_MC_AES_ECB_128Key_512BYTE_DATA   1


#define TST_USE_OTF_MC_AES_ECB_256Key_512BYTE_DATA   1
#define TST_USE_OTF_MC_AES_CBC_128Key_512BYTE_DATA   1
#define TST_USE_OTF_MC_AES_CBC_256Key_512BYTE_DATA   1
#define TST_USE_OTF_MC_AES_CTR_128Key_512BYTE_DATA   1


#define TST_USE_OTF_MC_AES_CTR_256Key_512BYTE_DATA   1
#define TST_USE_OTF_MC_AES_XTS_256Key_512BYTE_DATA   1

#define TST_USE_OTF_MC_AES_ECB_128Key_1024BYTE_DATA  1
#define TST_USE_OTF_MC_AES_ECB_256Key_1024BYTE_DATA  1
#define TST_USE_OTF_MC_AES_CBC_128Key_1024BYTE_DATA  1
#define TST_USE_OTF_MC_AES_CBC_256Key_1024BYTE_DATA  1
#define TST_USE_OTF_MC_AES_CTR_128Key_1024BYTE_DATA  1
#define TST_USE_OTF_MC_AES_CTR_256Key_1024BYTE_DATA  1
#define TST_USE_OTF_MC_AES_XTS_256Key_1024BYTE_DATA  1 

#define TST_USE_OTF_MC_AES_ECB_128Key_2048BYTE_DATA  1
#define TST_USE_OTF_MC_AES_ECB_256Key_2048BYTE_DATA  1
#define TST_USE_OTF_MC_AES_CBC_128Key_2048BYTE_DATA  1
#define TST_USE_OTF_MC_AES_CBC_256Key_2048BYTE_DATA  1
#define TST_USE_OTF_MC_AES_CTR_128Key_2048BYTE_DATA  1
#define TST_USE_OTF_MC_AES_CTR_256Key_2048BYTE_DATA  1
#define TST_USE_OTF_MC_AES_XTS_256Key_2048BYTE_DATA  1



/*flow*/
#ifdef CRYS_NO_FLOW_SUPPORT
    #define TST_USE_FLOW_AES_ECBMode_DATA     0
    #define TST_USE_FLOW_AES_CBCMode_DATA     0
    #define TST_USE_FLOW_AES_MACMode_DATA	  0
    #define TST_USE_FLOW_AES_CTRMode_DATA	  0
    #define TST_USE_FLOW_AES_XCBCMACMode_DATA 0
    #define TST_USE_FLOW_AES_CMACMode_DATA    0
    #define TST_USE_FLOW_DES_ECBMode_DATA     0
    #define TST_USE_FLOW_DES_CBCMode_DATA     0
    #define TST_USE_FLOW_HASH_SHA1Mode_DATA   0
    #define TST_USE_FLOW_HASH_SHA224Mode_DATA 0
    #define TST_USE_FLOW_HASH_SHA256Mode_DATA 0
    #define TST_USE_FLOW_HASH_MD5Mode_DATA    0
    #define TST_USE_FLOW_RC4_5BYTE_KEY        0
    #define TST_USE_FLOW_RC4_8BYTE_KEY        0
    #define TST_USE_FLOW_RC4_16BYTE_KEY       0
    /*  HMAC flow doesn't support 512, 384 modes */
    #define TST_USE_FLOW_HMAC_SHA1MODE_DATA   0
    #define TST_USE_FLOW_HMAC_SHA224MODE_DATA 0
    #define TST_USE_FLOW_HMAC_SHA256MODE_DATA 0
    #define TST_USE_FLOW_HMAC_MD5MODE_DATA    0
    #define TST_USE_FLOW_HASH_SHA384Mode_DATA 0 /* not supported yet in HW */
    #define TST_USE_FLOW_HASH_SHA512Mode_DATA 0 /* not supported yet in HW */
#else
    #define TST_USE_FLOW_AES_ECBMode_DATA     1
    #define TST_USE_FLOW_AES_CBCMode_DATA     1
    #define TST_USE_FLOW_AES_MACMode_DATA	  1
    #define TST_USE_FLOW_AES_CTRMode_DATA	  1
    #define TST_USE_FLOW_AES_XCBCMACMode_DATA 1
    #define TST_USE_FLOW_AES_CMACMode_DATA    1
    #define TST_USE_FLOW_DES_ECBMode_DATA     1
    #define TST_USE_FLOW_DES_CBCMode_DATA     1
    #define TST_USE_FLOW_HASH_SHA1Mode_DATA   1
    #define TST_USE_FLOW_HASH_SHA224Mode_DATA 1
    #define TST_USE_FLOW_HASH_SHA256Mode_DATA 1
    #define TST_USE_FLOW_HASH_MD5Mode_DATA    1
    #define TST_USE_FLOW_RC4_5BYTE_KEY        1
    #define TST_USE_FLOW_RC4_8BYTE_KEY        1
    #define TST_USE_FLOW_RC4_16BYTE_KEY       1
    /*  HMAC flow doesn't support 512, 384 modes */
	#define TST_USE_FLOW_HMAC_SHA1MODE_DATA   1
	#define TST_USE_FLOW_HMAC_SHA224MODE_DATA 1
	#define TST_USE_FLOW_HMAC_SHA256MODE_DATA 1
	#define TST_USE_FLOW_HMAC_MD5MODE_DATA    1
#ifndef LLF_HASH_SHA384_SHA512_NOT_SUPPORTED
    #define TST_USE_FLOW_HASH_SHA384Mode_DATA 1
    #define TST_USE_FLOW_HASH_SHA512Mode_DATA 1
#else
    #define TST_USE_FLOW_HASH_SHA384Mode_DATA 0 /* not supported yet in HW */
    #define TST_USE_FLOW_HASH_SHA512Mode_DATA 0 /* not supported yet in HW */
#endif
#endif /* CRYS_NO_FLOW_SUPPORT */

#ifndef CRYS_NO_AES_XTS_MODE_SUPPORT
    #define TST_USE_FLOW_AES_XTSMode_DATA     1 
#else
    #define TST_USE_FLOW_AES_XTSMode_DATA     0 /* not supported yet */
#endif



/* Define to Enable Secret key tests */
/*-----------------------------------*/
#define TST_USE_SECRETKEY_TESTS 0
#define TST_USE_PREDEFINED_SECRETKEY_TESTS 0 /* Use only if secret key was predefined to specific value*/

/* Print levels */
/*--------------*/
#define CRYS_ATP_TST_MSG 		10
#define CRYS_ATP_TST_DBG_HIGH 	20
#define CRYS_ATP_TST_DBG_MED	30
#define CRYS_ATP_TST_DBG_LOW 	40

/* Defines for tests Behavior */
/*----------------------------*/

#define CRYS_ATP_TST_EXIT_ON_ERROR  1
#define CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR 1
#define TST_FILE_PATH_LENGTH       1000

/*if the engine is SOFT then then define is 1 else is 0 */
#define TST_IF_RESET_IS_VOID_FUNCTION   !LLF_RND_ENGINE_TYPE

/* Test detailed defines */
/*-----------------------*/
/*General*/
/*-------*/
#define TST_FAIL         1
#define TST_PASS         0
#define TST_ENCRYPT      0 
#define TST_DECRYPT      1
#define TST_NULL_PTR     0
#define TST_ZERO_DATA 	 0
#define TST_NOT_DEVIDE_8 1

#define TST_NAME_STRING_LEN 150
#define TST_DATA_VEC_SIZE_IN_WORDS 4
#define TST_DATA_BLOCK 512
#define TST_MAX_DATA_VEC_SIZE_IN_BYTS 1536
#define TST_IV_NULL  0
#define TST_IV_VALUE 1


#define TST_EXTERNAL_KEYPAIR 1
/*Specific*/
/*--------*/
/* AES*//*---------------------------------------------------------------------*/
#define TST_CBC_MAC_SIZE 16
#define TST_AES_IV_SIZE  16
#define TST_MAX_SINGLE_AES_BLOCK_SIZE_IN_BYTS 16
#define TST_KEYWRAP_IV_SIZE_IN_BYTES 8
#define TST_XTS_FINISH_INPUT_MAX_SIZE 32 
/* This defines the vectors used in the tests and the sizes
according to selection at the top of the defines page*/
#define TST_USE_AES_DATA (TST_USE_AES_16BYTE_DATA|TST_USE_AES_32BYTE_DATA|TST_USE_AES_64BYTE_DATA|TST_USE_AES_512BYTE_DATA|TST_USE_AES_1536BYTE_DATA)
#if !TST_USE_AES_DATA
    #define TST_AES_DATA_VEC_SIZE_IN_BYTS 1
#else 
    #if TST_USE_AES_1536BYTE_DATA
        #define TST_AES_DATA_VEC_SIZE_IN_BYTS 1550
#else 
    #if TST_USE_AES_512BYTE_DATA
        #define TST_AES_DATA_VEC_SIZE_IN_BYTS 520
#else 
    #if TST_USE_AES_64BYTE_DATA
        #define TST_AES_DATA_VEC_SIZE_IN_BYTS 72
#else  
    #if TST_USE_AES_32BYTE_DATA
        #define TST_AES_DATA_VEC_SIZE_IN_BYTS 40
#else 
    #if TST_USE_AES_16BYTE_DATA
        #define TST_AES_DATA_VEC_SIZE_IN_BYTS 24
#endif
#endif
#endif
#endif
#endif
/*HASH*//*---------------------------------------------------------------------*/
#define TST_MAX_SINGLE_HASH_BLOCK_SIZE_IN_BYTS 16
#define TST_MAX_SINGLE_C2_HASH_BLOCK_SIZE_IN_BYTS 8
#define TST_HASH_SHA1 0
#define TST_HASH_MD5  1
/* This defines the vectors used in the tests and the sizes
according to selection at the top of the defines page*/
#define TST_USE_HASH_DATA (TST_USE_HASH_16BYTE_DATA|TST_USE_HASH_32BYTE_DATA|TST_USE_HASH_512BYTE_DATA|TST_USE_HASH_1536BYTE_DATA)
#if !TST_USE_HASH_DATA
    #define TST_HASH_DATA_VEC_SIZE_IN_BYTS 1
#else
    #if TST_USE_HASH_1536BYTE_DATA
        #define TST_HASH_DATA_VEC_SIZE_IN_BYTS 1536
#else
    #if TST_USE_HASH_512BYTE_DATA
        #define TST_HASH_DATA_VEC_SIZE_IN_BYTS 512
#else
    #if TST_USE_HASH_32BYTE_DATA
        #define TST_HASH_DATA_VEC_SIZE_IN_BYTS 32
#else
    #if TST_USE_HASH_16BYTE_DATA
        #define TST_HASH_DATA_VEC_SIZE_IN_BYTS 16
#endif
#endif
#endif
#endif
#endif
/*DES*//*---------------------------------------------------------------------*/
#define TST_MAX_SINGLE_DES_BLOCK_SIZE_IN_BYTS 8
#define TST_DES_CONTEXT_SWITCH_DATA_SIZE  2048
#define	TST_ERROR_DES_4_KEYSINUSE 	  4
#define	TST_ERROR_DES_0_KEYSINUSE 	  0
#define	TST_ERROR_ENCRYPTDECRYPTFLAG  8
#define	TST_ERROR_OPERATIONMODE       8
/* This defines the vectors used in the tests and the sizes
   according to selection at the top of the defines page*/
#define TST_USE_DES_DATA (TST_USE_DES_16BYTE_DATA|TST_USE_DES_32BYTE_DATA|TST_USE_DES_512BYTE_DATA|TST_USE_DES_1536BYTE_DATA)
#if !TST_USE_DES_DATA
    #define TST_DES_DATA_VEC_SIZE_IN_BYTS 1
#else
    #if TST_USE_DES_1536BYTE_DATA
        #define TST_DES_DATA_VEC_SIZE_IN_BYTS 1536
#else
    #if TST_USE_DES_512BYTE_DATA
        #define TST_DES_DATA_VEC_SIZE_IN_BYTS 512
#else
    #if TST_USE_DES_32BYTE_DATA
        #define TST_DES_DATA_VEC_SIZE_IN_BYTS 32
#else
    #if TST_USE_DES_16BYTE_DATA
        #define TST_DES_DATA_VEC_SIZE_IN_BYTS 16
#endif
#endif
#endif
#endif
#endif
/*HMAC*//*---------------------------------------------------------------------*/
#define TST_HMAC_MAX_KEY_SIZE 512
/* This defines the vectors used in the tests and the sizes
according to selection at the top of the defines page*/
#define TST_USE_HMAC_DATA (TST_USE_HMAC_28BYTE_DATA|TST_USE_HMAC_32BYTE_DATA|TST_USE_HMAC_65BYTE_DATA|TST_USE_HMAC_500BYTE_DATA|TST_USE_HMAC_1536BYTE_DATA)
#if !TST_USE_HMAC_DATA
    #define TST_HMAC_DATA_VEC_SIZE_IN_BYTS 1
#else
    #if TST_USE_HMAC_1536BYTE_DATA
        #define TST_HMAC_DATA_VEC_SIZE_IN_BYTS 1536
#else
    #if TST_USE_HMAC_500BYTE_DATA
        #define TST_HMAC_DATA_VEC_SIZE_IN_BYTS 500
#else
    #if TST_USE_HMAC_65BYTE_DATA
        #define TST_HMAC_DATA_VEC_SIZE_IN_BYTS 65
#else
    #if TST_USE_HMAC_32BYTE_DATA
        #define TST_HMAC_DATA_VEC_SIZE_IN_BYTS 32
#else
    #if TST_USE_HMAC_28BYTE_DATA
        #define TST_HMAC_DATA_VEC_SIZE_IN_BYTS 28
#endif
#endif
#endif
#endif
#endif
#endif
/*RSA*//*---------------------------------------------------------------------*/
#define TST_MAX_MOD_SIZE_IN_BYTES 256
#define TST_MAX_PRVT_EXP_SIZE_IN_BYTES 256
#define TST_MAX_PUB_EXP_SIZE_IN_BYTES 3
#define TST_MAX_SINGLE_RSA_SIGN_BLOCK_SIZE_IN_BYTS 16
#define TST_LESS_DATA_FOR_PKCS1V15_ENCRYPT	11 
#define TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA1	42
#define TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA224	58
#define TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA256	66
#define TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA384	98
#define TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA512	130
#define TST_NO_CRT 	 0
#define TST_CRT_MODE 1
#define TST_RSA_512_KEY_SIZE_IN_BYTES  64
#define TST_RSA_1024_KEY_SIZE_IN_BYTES 128

#define TST_USE_RSA_DATA (TST_USE_RSA_512_KEY|TST_USE_RSA_1024_KEY|TST_USE_RSA_2048_KEY)
/*Diffie Hellman*//*---------------------------------------------------------------------*/
#define TST_MAX_DH_KEY_SIZE             1024
#define TST_DH_ANSI924_DERIVATION_MODES 2
#define TST_DH_SECRET_DATA_GEN_TYPES    2
#define TST_DH_GET_SECRET_KEY_ASN1      0
#define TST_DH_HYBRID_MODE              1
#define TST_DH_NON_HYBRID_MODE          0
#define TST_DH_MAX_SECRET_LEN_BYTE      250
#define TST_USE_DH_DATA (TST_USE_DH_512_PRIME|TST_USE_DH_1024_PRIME|TST_USE_DH_2048_PRIME)
/*RC4*//*---------------------------------------------------------------------*/
#define TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS 1
/* This defines the vectors used in the tests and the sizes
   according to selection at the top of the defines page*/
#define TST_USE_RC4_DATA (TST_USE_RC4_16BYTE_DATA|TST_USE_RC4_32BYTE_DATA|TST_USE_RC4_41BYTE_DATA|TST_USE_RC4_512BYTE_DATA|TST_USE_RC4_1536BYTE_DATA)
#if !TST_USE_RC4_DATA
    #define TST_RC4_DATA_VEC_SIZE_IN_BYTS 1
#else
    #if TST_USE_RC4_1536BYTE_DATA
        #define TST_RC4_DATA_VEC_SIZE_IN_BYTS 1536
#else
    #if TST_USE_RC4_512BYTE_DATA
        #define TST_RC4_DATA_VEC_SIZE_IN_BYTS 512
#else
    #if TST_USE_RC4_41BYTE_DATA
        #define TST_RC4_DATA_VEC_SIZE_IN_BYTS 41
#else
    #if TST_USE_RC4_32BYTE_DATA
        #define TST_RC4_DATA_VEC_SIZE_IN_BYTS 32
#else
    #if TST_USE_RC4_16BYTE_DATA
        #define TST_RC4_DATA_VEC_SIZE_IN_BYTS 16
#endif
#endif
#endif
#endif
#endif
#endif
/*ECC*//*---------------------------------------------------------------------*/
#define TST_MAX_SINGLE_ECC_SIGN_BLOCK_SIZE_IN_BYTS 16
#define TST_MAX_ECC_KEY_SIZE_BYTES 256
/* This defines the vectors used in the tests and the sizes
according to selection at the top of the defines page*/
#define TST_USE_ECC_DATA (TST_USE_ECC_16BYTE_DATA|TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_27BYTE_DATA|TST_USE_ECC_31BYTE_DATA|TST_USE_ECC_48BYTE_DATA|TST_USE_ECC_64BYTE_DATA|TST_USE_ECC_128BYTE_DATA|TST_USE_ECC_256BYTE_DATA| \
        TST_USE_ECC_512BYTE_DATA|TST_USE_ECC_47BYTE_DATA|TST_USE_ECC_DH_DATA)
#if !TST_USE_ECC_DATA
    #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 1
#else
    #if TST_USE_ECC_DH_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 512
#else
    #if TST_USE_ECC_512BYTE_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 512
#else
    #if TST_USE_ECC_256BYTE_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 264
#else
    #if TST_USE_ECC_128BYTE_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 264
#else
    #if TST_USE_ECC_64BYTE_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 264
#else
    #if TST_USE_ECC_48BYTE_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 264
#else
    #if TST_USE_ECC_47BYTE_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 264
#else
    #if TST_USE_ECC_31BYTE_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 264
#else
    #if TST_USE_ECC_27BYTE_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 264
#else
    #if TST_USE_ECC_23BYTE_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 264
#else
    #if TST_USE_ECC_16BYTE_DATA
        #define TST_ECC_DATA_VEC_SIZE_IN_BYTS 264
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif

/*OTF*//*---------------------------------------------------------------------*/
/* This defines the vectors used in the tests 
according to selection at the top of the defines page */
#define TST_USE_OTF_DATA         (TST_USE_OTF_BYPASS|TST_USE_OTF_DIN_TO_AES_TO_DOUT| \
                                  TST_USE_OTF_DIN_TO_DES_TO_DOUT|TST_USE_OTF_DIN_TO_HASH| \
                                  TST_USE_OTF_DIN_TO_AES_TO_HASH|TST_USE_OTF_DIN_TO_AES_AND_HASH_TO_DOUT| \
                                  TST_USE_OTF_DIN_TO_AES_TO_HASH_AND_DOUT|TST_USE_OTF_DIN_TO_DES_TO_HASH| \
                                  TST_USE_OTF_DIN_TO_DES_AND_HASH_TO_DOUT|TST_USE_OTF_DIN_TO_AES_MAC| \
                                  TST_USE_OTF_DIN_TO_HASH_AND_DOUT|TST_USE_OTF_DIN_TO_AES_MAC_AND_TO_DOUT| \
                                  TST_USE_CSI_DATA)
                                  
								  								 
#if !TST_USE_OTF_DATA
    #define TST_OTF_DATA_VEC_SIZE_IN_BYTS 1
#else
  	#define TST_OTF_DATA_VEC_SIZE_IN_BYTS 512
#endif

/*OTF Multi Context for SymWave*//*---------------------------------------------------------------------*/
/* This defines the vectors used in the tests 
according to selection at the top of the defines page */

#define TST_USE_OTF_MC_DATA      (TST_USE_OTF_MC_AES_ECB_128Key_512BYTE_DATA|TST_USE_OTF_MC_AES_ECB_256Key_512BYTE_DATA| \
                                  TST_USE_OTF_MC_AES_CBC_128Key_512BYTE_DATA|TST_USE_OTF_MC_AES_CBC_256Key_512BYTE_DATA| \
                                  TST_USE_OTF_MC_AES_CTR_128Key_512BYTE_DATA|TST_USE_OTF_MC_AES_CTR_256Key_512BYTE_DATA| \
                                  TST_USE_OTF_MC_AES_XTS_256Key_512BYTE_DATA|TST_USE_OTF_MC_AES_ECB_128Key_1024BYTE_DATA| \
                                  TST_USE_OTF_MC_AES_ECB_256Key_1024BYTE_DATA|TST_USE_OTF_MC_AES_CBC_128Key_1024BYTE_DATA| \
                                  TST_USE_OTF_MC_AES_CBC_256Key_1024BYTE_DATA|TST_USE_OTF_MC_AES_CTR_128Key_1024BYTE_DATA| \
                                  TST_USE_OTF_MC_AES_CTR_256Key_1024BYTE_DATA|TST_USE_OTF_MC_AES_XTS_256Key_1024BYTE_DATA| \
                                  TST_USE_OTF_MC_AES_ECB_128Key_2048BYTE_DATA|TST_USE_OTF_MC_AES_ECB_256Key_2048BYTE_DATA| \
                                  TST_USE_OTF_MC_AES_CBC_128Key_2048BYTE_DATA|TST_USE_OTF_MC_AES_CBC_256Key_2048BYTE_DATA| \
                                  TST_USE_OTF_MC_AES_CTR_128Key_2048BYTE_DATA|TST_USE_OTF_MC_AES_CTR_256Key_2048BYTE_DATA| \
                                  TST_USE_OTF_MC_AES_XTS_256Key_2048BYTE_DATA)

#if !TST_USE_OTF_MC_DATA
    #define TST_OTF_MC_DATA_VEC_SIZE_IN_BYTS 1
#else
  	#define TST_OTF_MC_DATA_VEC_SIZE_IN_BYTS 2048
#endif

                                  
								  								 


/*FLOW*//*---------------------------------------------------------------------*/
/* This defines the vectors used in the tests 
according to selection at the top of the defines page */
#define TST_USE_FLOW_DATA        (TST_USE_FLOW_AES_ECBMode_DATA|TST_USE_FLOW_AES_CBCMode_DATA|\
                                   TST_USE_FLOW_AES_MACMode_DATA|TST_USE_FLOW_AES_CTRMode_DATA|\
                                   TST_USE_FLOW_AES_XCBCMACMode_DATA|TST_USE_FLOW_AES_CMACMode_DATA|\
                                   TST_USE_FLOW_AES_XTSMode_DATA|TST_USE_FLOW_DES_ECBMode_DATA|\
                                   TST_USE_FLOW_DES_CBCMode_DATA|TST_USE_FLOW_HASH_SHA1Mode_DATA|\
                                   TST_USE_FLOW_HASH_SHA224Mode_DATA|TST_USE_FLOW_HASH_SHA256Mode_DATA|\
                                   TST_USE_FLOW_HASH_SHA384Mode_DATA|TST_USE_FLOW_HASH_SHA512Mode_DATA|\
                                   TST_USE_FLOW_HASH_MD5Mode_DATA|TST_USE_FLOW_RC4_5BYTE_KEY|\
                                   TST_USE_FLOW_RC4_8BYTE_KEY|TST_USE_FLOW_RC4_16BYTE_KEY|\
                                   TST_USE_FLOW_HMAC_SHA1MODE_DATA|TST_USE_FLOW_HMAC_SHA224MODE_DATA|\
                                   TST_USE_FLOW_HMAC_SHA256MODE_DATA|TST_USE_FLOW_HMAC_MD5MODE_DATA) 
                                   
#define  FLOW_RC4_Support          TST_USE_FLOW_RC4_5BYTE_KEY|TST_USE_FLOW_RC4_8BYTE_KEY|TST_USE_FLOW_RC4_16BYTE_KEY                             
                                   
                                   
                                  
								  								 
#if !TST_USE_FLOW_DATA
    #define TST_FLOW_DATA_VEC_SIZE_IN_BYTS 1
#else
  	#define TST_FLOW_DATA_VEC_SIZE_IN_BYTS 512
#endif

#define TST_FLOW_DATA_MAX_NUM_OF_FLOWBUFFERS 10

								  
#define TST_OTF_KYESIZE_ZERO     0
#define TST_OTF_DOUT_OUTPUT      1
#define TST_OTF_HASH_OUTPUT      1
#define TST_OTF_MAC_OUTPUT       1
#define TST_OTF_NO_REMAIN_DATA   0

/*OTF CSI*//*---------------------------------------------------------------------*/
/* This defines the vectors used in the tests 
according to selection at the top of the defines page */
#define TST_USE_CSI_DATA           (TST_USE_DESCSI_DMA_TO_CSI|TST_USE_DESCSI_DMA_TO_DMA| \
                                    TST_USE_DESCSI_CSI_TO_DMA|TST_USE_AESCSI_DMA_TO_CSI| \
                                    TST_USE_AESCSI_DMA_TO_DMA|TST_USE_AESCSI_CSI_TO_DMA| \
                                    TST_USE_HASHCSI_DMA_TO_DMA|TST_USE_HASHCSI_CSI_TO_DMA| \
                                    TST_USE_HMAC_DMA_TO_DMA|TST_USE_HMAC_CSI_TO_DMA)                                  

#if !TST_USE_CSI_DATA
    #define TST_CSI_DATA_VEC_SIZE_IN_BYTS 1
#else
  	#define TST_CSI_DATA_VEC_SIZE_IN_BYTS 512
#endif



/*General*/
/*Define if any test data is used */
#define TST_USE_TEST_DATA (TST_USE_ECC_DATA|TST_USE_AES_DATA|TST_USE_DES_DATA|TST_USE_HMAC_DATA|TST_USE_HASH_DATA|TST_USE_RC4_DATA|TST_USE_RND_DATA| \
                           TST_USE_RSA_DATA|TST_USE_DH_DATA|TST_USE_OTF_DATA)

#ifdef __cplusplus
}
#endif
 
#endif

